<?php
/*
Plugin Name: State Laws
Plugin URL: http://
Description: State Laws
Version: 5.0
Author: Author
*/
/*
 * Register State Laws
 *
 */
function statelaws_setup_post_types() {

	$Statelaws =  apply_filters( 'statelaws_labels', array(
		'name'                => 'State Laws',
		'singular_name'       => 'State Laws',
		'add_new'             => __('Add New State Laws', 'State Laws'),
		'add_new_item'        => __('Add New State Laws', 'State Laws'),
		'edit_item'           => __('Edit State Laws', 'State Laws'),
		'edit_item'           => __('Edit State Laws', 'State Laws'),
		'new_item'            => __('New State Laws', 'State Laws'),
		'all_items'           => __('All State Laws', 'State Laws'),
		'view_item'           => __('View State Laws', 'State Laws'),
		'search_items'        => __('Search  State Laws', 'State Laws'),
		'not_found'           => __('No State Laws found', 'State Laws'),
		'not_found_in_trash'  => __('No State Laws found in Trash', 'State Laws'),
		'parent_item_colon'   => '',
		'menu_name'           => __('State Laws', 'State Laws'),
		'exclude_from_search' => true
	) );


	$statelawsargs = array(
		'labels' 			=> $Statelaws,
		'public' 			=> true,
		'publicly_queryable'=> true,
		'show_ui' 			=> true,
		'show_in_menu' 		=> true,
		'menu_icon'		 =>plugins_url('/map.png', __FILE__),
		'query_var' 		=> true,
		'capability_type' 	=> 'post',
		'has_archive' 		=> true,
		'hierarchical' 		=> true,
		'supports' 			=> apply_filters('statelaws_supports', array( 'title', 'editor','thumbnail') ),
	);
	register_post_type( 'statelaws', apply_filters( 'statelaws_post_type_args', $statelawsargs ) );

}

add_action('init', 'statelaws_setup_post_types');