<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Registrations */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Registrations'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="Registrations-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            //'id',
            //'user_id',
            [
               'label'=>'User',
               'format' => 'raw',
               'value'=>function ($data) {
                    return Html::a($data->user->username, ['user/update', 'id' => $data->user_id], ['target' => '_blank']);
                },
            ],
            'registration_no',
            'type_of_registration',
            'handler_first_name',
            'handler_last_name',
            'handler_street',
            'handler_city',
            'handler_state',
            'handler_zip',
            'handler_phone',
            'dog_name',
            'dog_breed',
            'user_ip',
            'source',
            'created_at',
            'updated_at',
            [
                'attribute'=>'created_at',
                'label'=>'Created on',
                'format'=>'date',//date,datetime, time
                'headerOptions' => ['width' => '200'],
            ],
            [
                'attribute'=>'updated_at',
                'label'=>'Last updated on',
                'format'=>'date',//date,datetime, time
                'headerOptions' => ['width' => '200'],
            ],
            
        ],
    ]) ?>

</div>
