<?php

namespace frontend\assets;

use yii\web\AssetBundle;
use yii\web\View;

/**
 * Main frontend application asset bundle.
 * @author Kartik Visweswaran <kartikv2@gmail.com>
 */
class AppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web/frontend/assets';
    public $css = [
        //'css/site.css',
        'css/carousel.css',
        //'css/bootstrap.css',

    
        'css/jquery-ui.min.css',
        'css/arconix-faq.css',
    
        //'css/genericons.css',
        'css/style.css',
        'css/scss.css',

        'css/flexslider.css',
        'css/font-awesome.css',
    
        'css/slick.css',

        'css/slimmenu.min.css',
        'css/media-queries.css',

    ];
    public $js = [
        'js/slick.min.js',
        'js/jquery.flexslider.js',
        'js/jquery.slimmenu.js',
        'js/jquery.easing.min.js',
        'js/owl.carousel.min.js',
    ];
     public $jsOptions = [
        'position' => View::POS_END
    ];
    public $cssOptions = [
        'position' => View::POS_END
    ];
    public $depends = [
        'yii\web\YiiAsset',
        'yii\bootstrap\BootstrapAsset',
        'yii\bootstrap\BootstrapPluginAsset',
    ];
}
