<?php

namespace common\models;

use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "registration".
 *
 * @property int $id
 * @property int $user_id
 * @property string $registration_no
 * @property string $type_of_registration
 * @property string $handler_first_name
 * @property string $handler_last_name
 * @property string $handler_street
 * @property string $handler_city
 * @property string $handler_state
 * @property string $handler_zip
 * @property string $handler_phone
 * @property string $dog_name
 * @property string $dog_breed
 * @property int $created_at
 * @property int $updated_at
 *
 * @property User $user
 */
class Registrations extends \yii\db\ActiveRecord
{
    public $email;
    public $password;
    public $repeat_email;
    public $repeat_password;
    public $verifyCode;


    const SCENARIO_CREATE = 'create';
    const SCENARIO_UPDATE = 'update';

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
         return [
            'timestamp' => [
                'class' => TimestampBehavior::className(),
                'attributes' => [
                    \yii\db\ActiveRecord::EVENT_BEFORE_INSERT => ['created_at', 'updated_at'],
                    \yii\db\ActiveRecord::EVENT_BEFORE_UPDATE => ['updated_at'],
                ],
                'value' => time(),
            ],           
        ];

    }

    public function scenarios()
    {
        $scenarios = parent::scenarios();
        $scenarios[self::SCENARIO_CREATE] = ['user_id', 'registration_no', 'type_of_registration', 'handler_first_name', 'handler_last_name', 'handler_street', 'handler_city', 'handler_state', 'handler_zip', 'handler_phone', 'dog_name', 'dog_breed', 'email', 'password', 'repeat_password', 'repeat_email', 'verifyCode'];
        $scenarios[self::SCENARIO_UPDATE] = ['user_id', 'registration_no', 'type_of_registration', 'handler_first_name', 'handler_last_name', 'handler_street', 'handler_city', 'handler_state', 'handler_zip', 'handler_phone', 'dog_name', 'dog_breed'];
        return $scenarios;
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'registration';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'registration_no', 'type_of_registration', 'handler_first_name', 'handler_last_name', 'handler_street', 'handler_city', 'handler_state', 'handler_zip', 'handler_phone', 'dog_name', 'dog_breed', 'email', 'password', 'repeat_password', 'repeat_email'], 'required', 'on' => self::SCENARIO_CREATE],
            [['user_id', 'registration_no', 'type_of_registration', 'handler_first_name', 'handler_last_name', 'handler_street', 'handler_city', 'handler_state', 'handler_zip', 'dog_name', 'dog_breed'], 'required', 'on' => self::SCENARIO_UPDATE],
            [['user_id', 'created_at', 'updated_at'], 'integer'],
            [
                ['handler_phone'],
                'integer',
                'message' => '{attribute} must be a number (example 8005551234)'
            ],
            [['registration_no', 'type_of_registration', 'handler_first_name', 'handler_last_name', 'handler_street', 'handler_city', 'handler_state', 'handler_zip', 'handler_phone', 'dog_breed', 'user_ip', 'source'], 'string', 'max' => 512],
            [['dog_name'], 'string', 'max' => 22],
            [['password'], 'string', 'min' => 8],
            [['email', 'repeat_email'],'email'],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
            ['repeat_password', 'compare', 'compareAttribute'=>'password', 'message'=>"Passwords don't match", 'on' => self::SCENARIO_CREATE ],
            ['repeat_email', 'compare', 'compareAttribute'=>'email', 'message'=>"Emails don't match", 'on' => self::SCENARIO_CREATE ],
            ['verifyCode', 'captcha', 'on' => self::SCENARIO_CREATE],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'registration_no' => 'Registration #',
            'type_of_registration' => 'Type of Registration',
            'handler_first_name' => 'First Name',
            'handler_last_name' => 'Last Name',
            'handler_street' => 'Street',
            'handler_city' => 'City',
            'handler_state' => 'State',
            'handler_zip' => 'Zip',
            'handler_phone' => 'Phone',
            'dog_name' => 'Dog\'s Name',
            'dog_breed' => 'Dog\'s Breed',
            'user_ip' => 'User\'s IP',
            'source' => 'Source',
            'verifyCode' => 'Verify text',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    public function generateUniqueRandomString ($length = 10) {
            
        //$randomString = Yii::$app->getSecurity()->generateRandomString($length);
        $randomString = strval(rand( 1000000000 , 2147483647 ));
                
        if(!$this->findOne(['registration_no' => $randomString]))
            return $randomString;
        else
            return $this->generateUniqueRandomString();
                
    }
}
